/***********************************************************************//**
 * @file		spxcodec.h
 * @brief		Contains all macro definitions and function prototypes
 * 				support for Speex CODEC
 * @version		1.0
 * @date		24. Apr. 2011
 * @author		CT-PIM
 **************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **************************************************************************/

#ifndef LPC17XX_SPXCODEC_H_
#define LPC17XX_SPXCODEC_H_

/* Includes ------------------------------------------------------------------- */
#include "lpc17xx.h"
#include "lpc_types.h"

#include "speex/speex.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#define SPX_VBR_ENABLED         1
#define SPX_VBR_DISABLED        0
#define SPX_ENHANCER_ENABLED    1
#define SPX_ENHANCER_DISABLED   0

#define CODEC_STATUS_IDLE       0
#define CODEC_STATUS_REC        1
#define CODEC_STATUS_PLAY       2

/* encoded (Speex) frame size */
#define SPEEX_FRAME_SIZE  	   20

#define AUDIO_SAMPLE_TOTAL_FRAMES  300

#define AUDIO_SAMPLE_RATE_8KHZ     125

#define ADC_CHANNEL__ ADC_CHANNEL_2
#define ADC_INT__     ADC_ADINTEN2
   
   
typedef struct
{
   uint32_t quality;	   /**< Set the encoding quality (0-10)   */
   uint32_t complexity;	   /**< Encoder complexity (1-10)         */
   uint32_t vbr;           /**< Enable VBR (Variable Bit-Rate)    */
   uint32_t enh;           /**< Enable post-filter                */
} SPX_CODEC_CFG_Type;


/**********************************************************************/
/* Public Functions Prototypes                                        */
/**********************************************************************/
extern void spx_Init(SPX_CODEC_CFG_Type *SpxCfg);
extern void spx_StartEncoder(void);
extern void spx_StartDecoder(void);
extern void AudioInput_Init(void);
extern void AudioOutput_Init(void);

#endif /* LPC17XX_SPXCODEC_H_ */